# 帳票設計書 15-Repositories Report

## 概要

本ドキュメントは、OpenSearchのCat API「/_cat/repositories」エンドポイントが出力するRepositories Reportの設計仕様を定義する。本帳票はクラスタに登録されたスナップショットリポジトリの一覧情報をテキストテーブル形式にて出力するものである。

### 本帳票の処理概要

本帳票は、OpenSearchクラスタに登録されたスナップショットリポジトリの名前と種類を一覧化する。GetRepositoriesRequestを用いてクラスタ内の全リポジトリ情報を取得し、シンプルな2カラムのテーブルとして出力する。

**業務上の目的・背景**：スナップショットリポジトリはデータバックアップ・リストアの基盤であり、リポジトリの登録状況を把握することは災害復旧（DR）やデータ管理において重要である。本帳票により登録済みリポジトリを一覧確認できる。

**帳票の利用シーン**：バックアップ運用の確認、リポジトリ登録後の確認、スナップショット取得前のリポジトリ確認、クラスタ構成の棚卸しに利用される。

**主要な出力内容**：
1. リポジトリID（名前）
2. リポジトリタイプ（fs, s3, azure, gcs等）

**帳票の出力タイミング**：ユーザーがREST APIエンドポイント `GET /_cat/repositories` にHTTPリクエストを送信した際にリアルタイムで生成・出力される。

**帳票の利用者**：OpenSearchクラスタ管理者、バックアップ運用担当者。

## 帳票種別

一覧表（スナップショットリポジトリ一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | REST API | `GET /_cat/repositories` | HTTPリクエスト送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | text/plain（テキストテーブル）またはJSON/YAML（format指定時） |
| 用紙サイズ | N/A（API応答） |
| 向き | N/A |
| ファイル名 | N/A（HTTPレスポンスボディ） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### PDF固有設定

該当なし

### Excel固有設定

該当なし

## 帳票レイアウト

### レイアウト概要

テキストテーブル形式で、1行が1リポジトリに対応するシンプルな一覧を出力する。

```
┌──────────────────────────────┐
│  ヘッダー部（id, type）       │
├──────────────────────────────┤
│  明細部（リポジトリごとに1行） │
│  例: my_backup    fs          │
│      s3_repo      s3          │
└──────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | id | リポジトリ名 | RepositoryMetadata.name() | 文字列（alias: repoId） |
| 2 | type | リポジトリタイプ | RepositoryMetadata.type() | 文字列（alias: t、右寄せ） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | id | リポジトリ名 | RepositoryMetadata.name() | 文字列 | 可変 |
| 2 | type | リポジトリタイプ | RepositoryMetadata.type() | 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| local | ローカルノードの情報のみ参照するか | No（デフォルト: false） |
| cluster_manager_timeout | クラスタマネージャへのタイムアウト | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リポジトリ順 | GetRepositoriesResponseのrepositories()イテレーション順 |

### 改ページ条件

改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| RepositoryMetadata（内部API） | リポジトリ情報取得 | GetRepositoriesRequest |

### テーブル別参照項目詳細

#### GetRepositoriesResponse

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| RepositoryMetadata.name() | id | - | リポジトリ名 |
| RepositoryMetadata.type() | type | - | fs, s3, azure, gcs等 |

## 計算仕様

### 計算項目一覧

本帳票に計算項目は存在しない。

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[クライアントからGETリクエスト受信] --> B[RestRepositoriesAction.doCatRequest]
    B --> C[GetRepositoriesRequest生成]
    C --> D[localパラメータ設定]
    D --> E[NodeClient.admin.cluster.getRepositories実行]
    E --> F[GetRepositoriesResponse受信]
    F --> G[buildTable: RepositoryMetadataをループ]
    G --> H[テーブル行追加（name, type）]
    H --> I[RestTable.buildResponse]
    I --> J[HTTPレスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | リポジトリが未登録の場合 | 空のテーブル（ヘッダーのみ） | 正常動作 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | リポジトリ数（典型的には数個） |
| 目標出力時間 | 通常1秒以内 |
| 同時出力数上限 | REST APIスレッドプールに依存 |

## セキュリティ考慮事項

リポジトリ情報にはストレージの構成情報が含まれるため、cluster:admin/repository/get 権限を持つユーザーのみアクセス可能とすべきである。

## 備考

- 非常にシンプルな2カラム構成の帳票
- `master_timeout` パラメータは非推奨

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RepositoryMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/RepositoryMetadata.java` | name()とtype()メソッド |

**読解のコツ**: RepositoryMetadataはシンプルな構造で、リポジトリの名前・タイプ・設定を保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestRepositoriesAction.java` | 帳票メインクラス。114行と非常に短い |

**主要処理フロー**:
1. **行60-62**: routes()で `/_cat/repositories` ルートを定義
2. **行65-81**: doCatRequest()でGetRepositoriesRequestを発行
3. **行66-71**: local, cluster_manager_timeout パラメータ設定
4. **行94-99**: getTableWithHeader()で2カラム定義（id, type）
5. **行101-113**: buildTable()でRepositoryMetadataのシンプルなループ

### プログラム呼び出し階層図

```
HTTP GET /_cat/repositories
    |
    +-- AbstractCatAction.prepareRequest()
        |
        +-- RestRepositoriesAction.doCatRequest() [行65]
            |
            +-- GetRepositoriesRequest [行66]
            +-- NodeClient.admin().cluster().getRepositories() [行73]
                |
                +-- RestResponseListener.buildResponse() [行77]
                    |
                    +-- buildTable() [行101]
                    |   +-- RepositoryMetadata loop [行103]
                    |       +-- table.addCell(name, type) [行106-107]
                    |
                    +-- RestTable.buildResponse() [行78]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTP GET Request   --> RestRepositoriesAction           --> HTTP Response
  /_cat/repositories    |                                   (text/plain
                        +-> GetRepositoriesRequest           or JSON)
                        +-> GetRepositoriesResponse
                        |   (List<RepositoryMetadata>)
                        +-> buildTable()
                        +-> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRepositoriesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestRepositoriesAction.java` | ソース | 帳票メインクラス（114行） |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API基底クラス |
| RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | ソース | テーブルレスポンス構築 |
| RepositoryMetadata.java | `server/src/main/java/org/opensearch/cluster/metadata/RepositoryMetadata.java` | ソース | リポジトリメタデータ |
| GetRepositoriesRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesRequest.java` | ソース | リポジトリ取得リクエスト |
| GetRepositoriesResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/repositories/get/GetRepositoriesResponse.java` | ソース | リポジトリ取得レスポンス |
| ActionModule.java | `server/src/main/java/org/opensearch/action/ActionModule.java` | ソース | アクション登録 |
